/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Buffer;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.NotImplemented;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.ResultSetMetaData;
import com.mysql.jdbc.RowDataStatic;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.Statement;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.TimeUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;

public class PreparedStatement
extends Statement
implements java.sql.PreparedStatement {
    private ArrayList batchedGeneratedKeys = null;
    private DatabaseMetaData dbmd = null;
    private ParseInfo parseInfo;
    private java.sql.ResultSetMetaData pstmtResultMetaData;
    private SimpleDateFormat tsdf = null;
    private String originalSql = null;
    private boolean[] isNull = null;
    private boolean[] isStream = null;
    private InputStream[] parameterStreams = null;
    private byte[][] parameterValues = null;
    private byte[][] staticSqlStrings = null;
    private byte[] streamConvertBuf = new byte[4096];
    private int[] streamLengths = null;
    private boolean hasLimitClause = false;
    private boolean isLoadDataQuery = false;
    private boolean retrieveGeneratedKeys = false;
    private boolean useTrueBoolean = false;
    private char firstCharOfStmt = '\u0000';

    public PreparedStatement(Connection conn, String sql, String catalog) throws SQLException {
        super(conn, catalog);
        if (sql == null) {
            throw new SQLException("SQL String can not be NULL", "S1009");
        }
        this.originalSql = sql;
        this.dbmd = this.connection.getMetaData();
        this.useTrueBoolean = this.connection.getIO().versionMeetsMinimum(3, 21, 23);
        this.parseInfo = new ParseInfo(sql, this.connection, this.dbmd, this.charEncoding, this.charConverter);
        this.initializeFromParseInfo();
    }

    public PreparedStatement(Connection conn, String sql, String catalog, ParseInfo cachedParseInfo) throws SQLException {
        super(conn, catalog);
        if (sql == null) {
            throw new SQLException("SQL String can not be NULL", "S1009");
        }
        this.originalSql = sql;
        this.dbmd = this.connection.getMetaData();
        this.useTrueBoolean = this.connection.getIO().versionMeetsMinimum(3, 21, 23);
        this.parseInfo = cachedParseInfo;
        this.initializeFromParseInfo();
    }

    public void setArray(int i2, Array x2) throws SQLException {
        throw new NotImplemented();
    }

    public synchronized void setAsciiStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        if (x2 == null) {
            this.setNull(parameterIndex, 12);
        } else {
            this.setBinaryStream(parameterIndex, x2, length);
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x2) throws SQLException {
        if (x2 == null) {
            this.setNull(parameterIndex, 3);
        } else {
            this.setInternal(parameterIndex, PreparedStatement.fixDecimalExponent(x2.toString()));
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        if (x2 == null) {
            this.setNull(parameterIndex, -2);
        } else {
            if (parameterIndex < 1 || parameterIndex > this.staticSqlStrings.length) {
                throw new SQLException("Parameter index out of range (" + parameterIndex + " > " + this.staticSqlStrings.length + ")", "S1009");
            }
            this.parameterStreams[parameterIndex - 1] = x2;
            this.isStream[parameterIndex - 1] = true;
            this.streamLengths[parameterIndex - 1] = length;
            this.isNull[parameterIndex - 1] = false;
        }
    }

    public void setBlob(int i2, Blob x2) throws SQLException {
        this.setBinaryStream(i2, x2.getBinaryStream(), (int)x2.length());
    }

    public void setBoolean(int parameterIndex, boolean x2) throws SQLException {
        if (this.useTrueBoolean) {
            this.setInternal(parameterIndex, x2 ? "'1'" : "'0'");
        } else {
            this.setInternal(parameterIndex, x2 ? "'t'" : "'f'");
        }
    }

    public void setByte(int parameterIndex, byte x2) throws SQLException {
        this.setInternal(parameterIndex, String.valueOf(x2));
    }

    public void setBytes(int parameterIndex, byte[] x2) throws SQLException {
        if (x2 == null) {
            this.setNull(parameterIndex, -2);
        } else {
            int numBytes = x2.length;
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(numBytes);
            bOut.write(39);
            int i2 = 0;
            while (i2 < numBytes) {
                byte b2 = x2[i2];
                switch (b2) {
                    case 0: {
                        bOut.write(92);
                        bOut.write(48);
                        break;
                    }
                    case 10: {
                        bOut.write(92);
                        bOut.write(110);
                        break;
                    }
                    case 13: {
                        bOut.write(92);
                        bOut.write(114);
                        break;
                    }
                    case 92: {
                        bOut.write(92);
                        bOut.write(92);
                        break;
                    }
                    case 39: {
                        bOut.write(92);
                        bOut.write(39);
                        break;
                    }
                    case 34: {
                        bOut.write(92);
                        bOut.write(34);
                        break;
                    }
                    case 26: {
                        bOut.write(92);
                        bOut.write(90);
                        break;
                    }
                    default: {
                        bOut.write(b2);
                    }
                }
                ++i2;
            }
            bOut.write(39);
            this.setInternal(parameterIndex, bOut.toByteArray());
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            if (reader == null) {
                this.setNull(parameterIndex, -1);
            } else {
                char[] c2 = null;
                int len = 0;
                boolean useLength = this.connection.useStreamLengthsInPrepStmts();
                if (useLength && length != -1) {
                    c2 = new char[length];
                    int numCharsRead = PreparedStatement.readFully(reader, c2, length);
                    this.setString(parameterIndex, new String(c2, 0, numCharsRead));
                } else {
                    c2 = new char[4096];
                    StringBuffer buf = new StringBuffer();
                    while ((len = reader.read(c2)) != -1) {
                        buf.append(c2, 0, len);
                    }
                    this.setString(parameterIndex, buf.toString());
                }
            }
        }
        catch (IOException ioEx) {
            throw new SQLException(ioEx.toString(), "S1000");
        }
    }

    public void setClob(int i2, Clob x2) throws SQLException {
        this.setString(i2, x2.getSubString(1L, (int)x2.length()));
    }

    public void setDate(int parameterIndex, Date x2) throws SQLException {
        if (x2 == null) {
            this.setNull(parameterIndex, 91);
        } else {
            SimpleDateFormat dateFormatter = new SimpleDateFormat("''yyyy-MM-dd''");
            this.setInternal(parameterIndex, dateFormatter.format(x2));
        }
    }

    public void setDate(int parameterIndex, Date x2, Calendar cal) throws SQLException {
        this.setDate(parameterIndex, x2);
    }

    public void setDouble(int parameterIndex, double x2) throws SQLException {
        this.setInternal(parameterIndex, PreparedStatement.fixDecimalExponent(String.valueOf(x2)));
    }

    public void setFloat(int parameterIndex, float x2) throws SQLException {
        this.setInternal(parameterIndex, PreparedStatement.fixDecimalExponent(String.valueOf(x2)));
    }

    public synchronized java.sql.ResultSet getGeneratedKeys() throws SQLException {
        if (this.batchedGeneratedKeys == null) {
            return super.getGeneratedKeys();
        }
        Field[] fields = new Field[]{new Field("", "GENERATED_KEY", -5, 17)};
        return new ResultSet(this.currentCatalog, fields, new RowDataStatic(this.batchedGeneratedKeys), this.connection);
    }

    public void setInt(int parameterIndex, int x2) throws SQLException {
        this.setInternal(parameterIndex, String.valueOf(x2));
    }

    public void setLong(int parameterIndex, long x2) throws SQLException {
        this.setInternal(parameterIndex, String.valueOf(x2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized java.sql.ResultSetMetaData getMetaData() throws SQLException {
        PreparedStatement mdStmt = null;
        java.sql.ResultSet mdRs = null;
        if (this.pstmtResultMetaData == null) {
            SQLException sqlEx22;
            SQLException sqlExRethrow2;
            block17: {
                try {
                    mdStmt = new PreparedStatement(this.connection, this.originalSql, this.currentCatalog, this.parseInfo);
                    mdStmt.setMaxRows(0);
                    int paramCount = this.parameterValues.length;
                    int i2 = 1;
                    while (i2 <= paramCount) {
                        mdStmt.setString(i2, "");
                        ++i2;
                    }
                    boolean hadResults = mdStmt.execute();
                    if (hadResults) {
                        mdRs = mdStmt.getResultSet();
                        this.pstmtResultMetaData = mdRs.getMetaData();
                    } else {
                        this.pstmtResultMetaData = new ResultSetMetaData(new Field[0]);
                    }
                    Object var7_6 = null;
                    sqlExRethrow2 = null;
                    if (mdRs == null) break block17;
                }
                catch (Throwable throwable) {
                    SQLException sqlEx22;
                    Object var7_7 = null;
                    SQLException sqlExRethrow2 = null;
                    if (mdRs != null) {
                        try {
                            mdRs.close();
                        }
                        catch (SQLException sqlEx22) {
                            sqlExRethrow2 = sqlEx22;
                        }
                        mdRs = null;
                    }
                    if (mdStmt != null) {
                        try {
                            mdStmt.close();
                        }
                        catch (SQLException sqlEx22) {
                            sqlExRethrow2 = sqlEx22;
                        }
                        mdStmt = null;
                    }
                    if (sqlExRethrow2 != null) {
                        throw sqlExRethrow2;
                    }
                    throw throwable;
                }
                try {
                    mdRs.close();
                }
                catch (SQLException sqlEx22) {
                    sqlExRethrow2 = sqlEx22;
                }
                mdRs = null;
            }
            if (mdStmt != null) {
                try {
                    mdStmt.close();
                }
                catch (SQLException sqlEx22) {
                    sqlExRethrow2 = sqlEx22;
                }
                mdStmt = null;
            }
            if (sqlExRethrow2 != null) {
                throw sqlExRethrow2;
            }
        }
        return this.pstmtResultMetaData;
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setInternal(parameterIndex, "null");
        this.isNull[parameterIndex - 1] = true;
    }

    public void setNull(int parameterIndex, int sqlType, String arg) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    public void setObject(int parameterIndex, Object parameterObj, int targetSqlType, int scale) throws SQLException {
        if (parameterObj == null) {
            this.setNull(parameterIndex, 1111);
        } else {
            try {
                block1 : switch (targetSqlType) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        Number parameterAsNum;
                        if (parameterObj instanceof Boolean) {
                            parameterAsNum = (Boolean)parameterObj != false ? new Integer(1) : new Integer(0);
                        } else if (parameterObj instanceof String) {
                            switch (targetSqlType) {
                                case -7: {
                                    parameterAsNum = Boolean.getBoolean((String)parameterObj) ? new Integer("1") : new Integer("0");
                                    break;
                                }
                                case -6: 
                                case 4: 
                                case 5: {
                                    parameterAsNum = Integer.valueOf((String)parameterObj);
                                    break;
                                }
                                case -5: {
                                    parameterAsNum = Long.valueOf((String)parameterObj);
                                    break;
                                }
                                case 7: {
                                    parameterAsNum = Float.valueOf((String)parameterObj);
                                    break;
                                }
                                case 6: 
                                case 8: {
                                    parameterAsNum = Double.valueOf((String)parameterObj);
                                    break;
                                }
                                default: {
                                    parameterAsNum = new BigDecimal((String)parameterObj);
                                    break;
                                }
                            }
                        } else {
                            parameterAsNum = (Number)parameterObj;
                        }
                        switch (targetSqlType) {
                            case -7: 
                            case -6: 
                            case 4: 
                            case 5: {
                                this.setInt(parameterIndex, parameterAsNum.intValue());
                                break block1;
                            }
                            case -5: {
                                this.setLong(parameterIndex, parameterAsNum.longValue());
                                break block1;
                            }
                            case 7: {
                                this.setFloat(parameterIndex, parameterAsNum.floatValue());
                                break block1;
                            }
                            case 6: 
                            case 8: {
                                this.setDouble(parameterIndex, parameterAsNum.doubleValue());
                                break block1;
                            }
                        }
                        if (parameterAsNum instanceof BigDecimal) {
                            this.setBigDecimal(parameterIndex, (BigDecimal)parameterAsNum);
                            break;
                        }
                        if (parameterAsNum instanceof BigInteger) {
                            this.setBigDecimal(parameterIndex, new BigDecimal((BigInteger)parameterAsNum, scale));
                            break;
                        }
                        this.setBigDecimal(parameterIndex, new BigDecimal(parameterAsNum.doubleValue()));
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        this.setString(parameterIndex, parameterObj.toString());
                        break;
                    }
                    case 2005: {
                        if (parameterObj instanceof Clob) {
                            this.setClob(parameterIndex, (Clob)parameterObj);
                            break;
                        }
                        this.setString(parameterIndex, parameterObj.toString());
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        if (parameterObj instanceof byte[]) {
                            this.setBytes(parameterIndex, (byte[])parameterObj);
                            break;
                        }
                        if (parameterObj instanceof Blob) {
                            this.setBlob(parameterIndex, (Blob)parameterObj);
                            break;
                        }
                        this.setBytes(parameterIndex, StringUtils.getBytes(parameterObj.toString(), this.charConverter, this.charEncoding, this.connection.parserKnowsUnicode()));
                        break;
                    }
                    case 91: 
                    case 93: {
                        java.util.Date parameterAsDate;
                        if (parameterObj instanceof String) {
                            ParsePosition pp = new ParsePosition(0);
                            SimpleDateFormat sdf = new SimpleDateFormat(this.getDateTimePattern((String)parameterObj, false));
                            parameterAsDate = ((DateFormat)sdf).parse((String)parameterObj, pp);
                        } else {
                            parameterAsDate = (java.util.Date)parameterObj;
                        }
                        switch (targetSqlType) {
                            case 91: {
                                if (parameterAsDate instanceof Date) {
                                    this.setDate(parameterIndex, (Date)parameterAsDate);
                                    break block1;
                                }
                                this.setDate(parameterIndex, new Date(parameterAsDate.getTime()));
                                break block1;
                            }
                            case 93: {
                                if (parameterAsDate instanceof Timestamp) {
                                    this.setTimestamp(parameterIndex, (Timestamp)parameterAsDate);
                                    break block1;
                                }
                                this.setTimestamp(parameterIndex, new Timestamp(parameterAsDate.getTime()));
                            }
                        }
                        break;
                    }
                    case 92: {
                        if (parameterObj instanceof String) {
                            SimpleDateFormat sdf = new SimpleDateFormat(this.getDateTimePattern((String)parameterObj, true));
                            this.setTime(parameterIndex, new Time(sdf.parse((String)parameterObj).getTime()));
                            break;
                        }
                        if (parameterObj instanceof Timestamp) {
                            Timestamp xT = (Timestamp)parameterObj;
                            this.setTime(parameterIndex, new Time(xT.getTime()));
                            break;
                        }
                        this.setTime(parameterIndex, (Time)parameterObj);
                        break;
                    }
                    case 1111: {
                        this.setSerializableObject(parameterIndex, parameterObj);
                        break;
                    }
                    default: {
                        throw new SQLException("Unknown Types value", "S1000");
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof SQLException) {
                    throw (SQLException)ex;
                }
                throw new SQLException("Cannot convert " + parameterObj.getClass().toString() + " to SQL type requested due to " + ex.getClass().getName() + " - " + ex.getMessage(), "S1000");
            }
        }
    }

    public void setObject(int parameterIndex, Object parameterObj, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, parameterObj, targetSqlType, 0);
    }

    public void setObject(int parameterIndex, Object parameterObj) throws SQLException {
        if (parameterObj == null) {
            this.setNull(parameterIndex, 1111);
        } else if (parameterObj instanceof Byte) {
            this.setInt(parameterIndex, ((Byte)parameterObj).intValue());
        } else if (parameterObj instanceof String) {
            this.setString(parameterIndex, (String)parameterObj);
        } else if (parameterObj instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)parameterObj);
        } else if (parameterObj instanceof Short) {
            this.setShort(parameterIndex, (Short)parameterObj);
        } else if (parameterObj instanceof Integer) {
            this.setInt(parameterIndex, (Integer)parameterObj);
        } else if (parameterObj instanceof Long) {
            this.setLong(parameterIndex, (Long)parameterObj);
        } else if (parameterObj instanceof Float) {
            this.setFloat(parameterIndex, ((Float)parameterObj).floatValue());
        } else if (parameterObj instanceof Double) {
            this.setDouble(parameterIndex, (Double)parameterObj);
        } else if (parameterObj instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])parameterObj);
        } else if (parameterObj instanceof Date) {
            this.setDate(parameterIndex, (Date)parameterObj);
        } else if (parameterObj instanceof Time) {
            this.setTime(parameterIndex, (Time)parameterObj);
        } else if (parameterObj instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)parameterObj);
        } else if (parameterObj instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)parameterObj);
        } else if (parameterObj instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)parameterObj, -1);
        } else if (parameterObj instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)parameterObj);
        } else if (parameterObj instanceof Clob) {
            this.setClob(parameterIndex, (Clob)parameterObj);
        } else if (parameterObj instanceof java.util.Date) {
            this.setTimestamp(parameterIndex, new Timestamp(((java.util.Date)parameterObj).getTime()));
        } else {
            this.setSerializableObject(parameterIndex, parameterObj);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new NotImplemented();
    }

    public void setRef(int i2, Ref x2) throws SQLException {
        throw new NotImplemented();
    }

    public void setShort(int parameterIndex, short x2) throws SQLException {
        this.setInternal(parameterIndex, String.valueOf(x2));
    }

    public void setString(int parameterIndex, String x2) throws SQLException {
        if (x2 == null) {
            try {
                this.setInternal(parameterIndex, StringUtils.getBytes("null", this.charConverter, this.charEncoding, this.connection.parserKnowsUnicode()));
            }
            catch (UnsupportedEncodingException uue) {
                throw new SQLException("Unsupported character encoding '" + this.charEncoding + "'", "S1009");
            }
        }
        StringBuffer buf = new StringBuffer((int)((double)x2.length() * 1.1));
        buf.append('\'');
        int stringLength = x2.length();
        int i2 = 0;
        while (i2 < stringLength) {
            char c2 = x2.charAt(i2);
            switch (c2) {
                case '\u0000': {
                    buf.append('\\');
                    buf.append('0');
                    break;
                }
                case '\n': {
                    buf.append('\\');
                    buf.append('n');
                    break;
                }
                case '\r': {
                    buf.append('\\');
                    buf.append('r');
                    break;
                }
                case '\\': {
                    buf.append('\\');
                    buf.append('\\');
                    break;
                }
                case '\'': {
                    buf.append('\\');
                    buf.append('\'');
                    break;
                }
                case '\"': {
                    buf.append('\\');
                    buf.append('\"');
                    break;
                }
                case '\u001a': {
                    buf.append('\\');
                    buf.append('Z');
                    break;
                }
                default: {
                    buf.append(c2);
                }
            }
            ++i2;
        }
        buf.append('\'');
        String parameterAsString = buf.toString();
        try {
            byte[] parameterAsBytes = null;
            parameterAsBytes = !this.isLoadDataQuery ? StringUtils.getBytes(parameterAsString, this.charConverter, this.charEncoding, this.connection.parserKnowsUnicode()) : parameterAsString.getBytes();
            this.setInternal(parameterIndex, parameterAsBytes);
        }
        catch (UnsupportedEncodingException uue) {
            throw new SQLException("Unsupported character encoding '" + this.charEncoding + "'", "S1009");
        }
    }

    public void setTime(int parameterIndex, Time x2) throws SQLException {
        this.setTimeInternal(parameterIndex, x2, this.connection.getDefaultTimeZone());
    }

    public void setTime(int parameterIndex, Time x2, Calendar cal) throws SQLException {
        this.setTimeInternal(parameterIndex, x2, cal.getTimeZone());
    }

    public void setTimestamp(int parameterIndex, Timestamp x2) throws SQLException {
        this.setTimestampInternal(parameterIndex, x2, this.connection.getDefaultTimeZone());
    }

    public void setTimestamp(int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        this.setTimestampInternal(parameterIndex, x2, cal.getTimeZone());
    }

    public void setURL(int parameterIndex, URL arg) throws SQLException {
        if (arg != null) {
            this.setString(parameterIndex, arg.toString());
        } else {
            this.setNull(parameterIndex, 1);
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        if (x2 == null) {
            this.setNull(parameterIndex, 12);
        } else {
            this.setBinaryStream(parameterIndex, x2, length);
        }
    }

    public void addBatch() throws SQLException {
        if (this.batchedArgs == null) {
            this.batchedArgs = new ArrayList();
        }
        this.batchedArgs.add(new BatchParams(this.parameterValues, this.parameterStreams, this.isStream, this.streamLengths, this.isNull));
    }

    public void clearParameters() throws SQLException {
        int i2 = 0;
        while (i2 < this.parameterValues.length) {
            this.parameterValues[i2] = null;
            this.parameterStreams[i2] = null;
            this.isStream[i2] = false;
            this.isNull[i2] = false;
            ++i2;
        }
    }

    public void close() throws SQLException {
        super.close();
        this.parseInfo = null;
        this.dbmd = null;
        this.originalSql = null;
        this.staticSqlStrings = null;
        this.parameterValues = null;
        this.parameterStreams = null;
        this.isStream = null;
        this.streamLengths = null;
        this.isNull = null;
        this.streamConvertBuf = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        if (this.connection.isReadOnly() && this.firstCharOfStmt != 'S') {
            throw new SQLException("Connection is read-only. Queries leading to data modification are not allowed", "S1009");
        }
        this.checkClosed();
        ResultSet rs = null;
        Object object = this.connection.getMutex();
        synchronized (object) {
            this.batchedGeneratedKeys = null;
            Buffer sendPacket = this.fillSendPacket();
            String oldCatalog = null;
            if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                oldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(this.currentCatalog);
            }
            boolean oldInfoMsgState = false;
            if (this.retrieveGeneratedKeys) {
                oldInfoMsgState = this.connection.isReadInfoMsgEnabled();
                this.connection.setReadInfoMsgEnabled(true);
            }
            if (this.connection.useMaxRows()) {
                if (this.firstCharOfStmt == 'S') {
                    if (this.hasLimitClause) {
                        rs = this.connection.execSQL(null, this.maxRows, sendPacket, this.resultSetConcurrency, this.createStreamingResultSet(), true, this.currentCatalog);
                    } else if (this.maxRows <= 0) {
                        this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, this.currentCatalog);
                    } else {
                        this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=" + this.maxRows, -1, this.currentCatalog);
                    }
                } else {
                    this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, this.currentCatalog);
                }
                rs = this.connection.execSQL(null, -1, sendPacket, this.resultSetConcurrency, this.createStreamingResultSet(), this.firstCharOfStmt == 'S', this.currentCatalog);
            } else {
                rs = this.connection.execSQL(null, -1, sendPacket, this.resultSetConcurrency, this.createStreamingResultSet(), this.firstCharOfStmt == 'S', this.currentCatalog);
            }
            if (this.retrieveGeneratedKeys) {
                this.connection.setReadInfoMsgEnabled(oldInfoMsgState);
            }
            if (oldCatalog != null) {
                this.connection.setCatalog(oldCatalog);
            }
            this.lastInsertId = rs.getUpdateID();
            if (rs != null) {
                rs.setFirstCharOfQuery(this.firstCharOfStmt);
                rs.setConnection(this.connection);
                rs.setResultSetType(this.resultSetType);
                rs.setResultSetConcurrency(this.resultSetConcurrency);
                rs.setStatement(this);
                this.results = rs;
            }
            boolean bl = rs != null && rs.reallyResult();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        if (this.connection.isReadOnly()) {
            throw new SQLException("Connection is read-only. Queries leading to data modification are not allowed", "S1009");
        }
        try {
            int[] updateCounts = null;
            if (this.batchedArgs != null) {
                int commandIndex;
                Throwable sqlEx;
                int nbrCommands = this.batchedArgs.size();
                updateCounts = new int[nbrCommands];
                int i2 = 0;
                while (true) {
                    if (i2 >= nbrCommands) {
                        sqlEx = null;
                        commandIndex = 0;
                        if (this.retrieveGeneratedKeys) {
                            this.batchedGeneratedKeys = new ArrayList(nbrCommands);
                        }
                        break;
                    }
                    updateCounts[i2] = -3;
                    ++i2;
                }
                commandIndex = 0;
                while (true) {
                    block18: {
                        if (commandIndex >= nbrCommands) {
                            if (sqlEx == null) break;
                            throw new BatchUpdateException(sqlEx.getMessage(), ((SQLException)sqlEx).getSQLState(), ((SQLException)sqlEx).getErrorCode(), updateCounts);
                        }
                        Object arg = this.batchedArgs.get(commandIndex);
                        if (arg instanceof String) {
                            updateCounts[commandIndex] = this.executeUpdate((String)arg);
                        } else {
                            BatchParams paramArg = (BatchParams)arg;
                            try {
                                Object var10_11;
                                updateCounts[commandIndex] = this.executeUpdate(paramArg.parameterStrings, paramArg.parameterStreams, paramArg.isStream, paramArg.streamLengths, paramArg.isNull);
                                if (!this.retrieveGeneratedKeys) break block18;
                                java.sql.ResultSet rs = null;
                                try {
                                    rs = super.getGeneratedKeys();
                                    while (true) {
                                        if (!rs.next()) {
                                            var10_11 = null;
                                            if (rs == null) break block18;
                                            break;
                                        }
                                        this.batchedGeneratedKeys.add(new byte[][]{rs.getBytes(1)});
                                    }
                                }
                                catch (Throwable throwable) {
                                    var10_11 = null;
                                    if (rs == null) throw throwable;
                                    rs.close();
                                    throw throwable;
                                }
                                rs.close();
                            }
                            catch (SQLException ex) {
                                updateCounts[commandIndex] = -3;
                                if (!this.connection.continueBatchOnError()) {
                                    int[] newUpdateCounts = new int[commandIndex];
                                    System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                                    throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), newUpdateCounts);
                                }
                                sqlEx = ex;
                            }
                        }
                    }
                    ++commandIndex;
                }
            }
            nArray = updateCounts != null ? updateCounts : new int[]{};
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            this.clearBatch();
            throw throwable;
        }
        this.clearBatch();
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized java.sql.ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        if ((this.firstCharOfStmt == 'I' || this.firstCharOfStmt == 'U' || this.firstCharOfStmt == 'D' || this.firstCharOfStmt == 'A' || this.firstCharOfStmt == 'C') && (StringUtils.startsWithIgnoreCaseAndWs(this.originalSql, "INSERT") || StringUtils.startsWithIgnoreCaseAndWs(this.originalSql, "UPDATE") || StringUtils.startsWithIgnoreCaseAndWs(this.originalSql, "DELETE") || StringUtils.startsWithIgnoreCaseAndWs(this.originalSql, "DROP") || StringUtils.startsWithIgnoreCaseAndWs(this.originalSql, "CREATE") || StringUtils.startsWithIgnoreCaseAndWs(this.originalSql, "ALTER"))) {
            throw new SQLException("Can not issue data manipulation statements with executeQuery()", "S1009");
        }
        Object object = this.connection.getMutex();
        synchronized (object) {
            this.batchedGeneratedKeys = null;
            Buffer sendPacket = this.fillSendPacket();
            if (this.results != null) {
                this.results.close();
            }
            String oldCatalog = null;
            if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                oldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(this.currentCatalog);
            }
            if (this.connection.useMaxRows()) {
                if (this.hasLimitClause) {
                    this.results = this.connection.execSQL(null, this.maxRows, sendPacket, this.resultSetConcurrency, this.createStreamingResultSet(), true, this.currentCatalog);
                } else {
                    if (this.maxRows <= 0) {
                        this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, this.currentCatalog);
                    } else {
                        this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=" + this.maxRows, -1, this.currentCatalog);
                    }
                    this.results = this.connection.execSQL(null, -1, sendPacket, this.resultSetConcurrency, this.createStreamingResultSet(), true, this.currentCatalog);
                    if (oldCatalog != null) {
                        this.connection.setCatalog(oldCatalog);
                    }
                }
            } else {
                this.results = this.connection.execSQL(null, -1, sendPacket, this.resultSetConcurrency, this.createStreamingResultSet(), true, this.currentCatalog);
            }
            if (oldCatalog != null) {
                this.connection.setCatalog(oldCatalog);
            }
        }
        this.lastInsertId = this.results.getUpdateID();
        this.nextResults = this.results;
        this.results.setConnection(this.connection);
        this.results.setResultSetType(this.resultSetType);
        this.results.setResultSetConcurrency(this.resultSetConcurrency);
        this.results.setStatement(this);
        return this.results;
    }

    public synchronized int executeUpdate() throws SQLException {
        this.batchedGeneratedKeys = null;
        return this.executeUpdate(this.parameterValues, this.parameterStreams, this.isStream, this.streamLengths, this.isNull);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append(": ");
        try {
            int i2 = 0;
            while (i2 < this.parameterValues.length) {
                if (this.charEncoding != null) {
                    buf.append(new String(this.staticSqlStrings[i2], this.charEncoding));
                } else {
                    buf.append(new String(this.staticSqlStrings[i2]));
                }
                if (this.parameterValues[i2] == null && !this.isStream[i2]) {
                    buf.append("** NOT SPECIFIED **");
                } else if (this.isStream[i2]) {
                    buf.append("** STREAM DATA **");
                } else if (this.charConverter != null) {
                    buf.append(this.charConverter.toString(this.parameterValues[i2]));
                } else if (this.charEncoding != null) {
                    buf.append(new String(this.parameterValues[i2], this.charEncoding));
                } else {
                    buf.append(StringUtils.toAsciiString(this.parameterValues[i2]));
                }
                ++i2;
            }
            if (this.charEncoding != null) {
                buf.append(new String(this.staticSqlStrings[this.parameterValues.length], this.charEncoding));
            } else {
                buf.append(this.staticSqlStrings[this.parameterValues.length]);
            }
        }
        catch (UnsupportedEncodingException uue) {
            throw new RuntimeException("Unsupported character encoding '" + this.charEncoding + "'");
        }
        return buf.toString();
    }

    protected void setBytesNoEscape(int parameterIndex, byte[] parameterAsBytes) throws SQLException {
        byte[] parameterWithQuotes = new byte[parameterAsBytes.length + 2];
        parameterWithQuotes[0] = 39;
        System.arraycopy(parameterAsBytes, 0, parameterWithQuotes, 1, parameterAsBytes.length);
        parameterWithQuotes[parameterAsBytes.length + 1] = 39;
        this.setInternal(parameterIndex, parameterWithQuotes);
    }

    protected void setRetrieveGeneratedKeys(boolean retrieveGeneratedKeys) {
        this.retrieveGeneratedKeys = retrieveGeneratedKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int executeUpdate(byte[][] batchedParameterStrings, InputStream[] batchedParameterStreams, boolean[] batchedIsStream, int[] batchedStreamLengths, boolean[] batchedIsNull) throws SQLException {
        if (this.connection.isReadOnly()) {
            throw new SQLException("Connection is read-only. Queries leading to data modification are not allowed", "S1009");
        }
        this.checkClosed();
        if (this.firstCharOfStmt == 'S' && StringUtils.startsWithIgnoreCaseAndWs(this.originalSql, "SELECT")) {
            throw new SQLException("Can not issue executeUpdate() for SELECTs", "S1009");
        }
        ResultSet rs = null;
        Object object = this.connection.getMutex();
        synchronized (object) {
            Buffer sendPacket = this.fillSendPacket(batchedParameterStrings, batchedParameterStreams, batchedIsStream, batchedStreamLengths);
            String oldCatalog = null;
            if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                oldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(this.currentCatalog);
            }
            if (this.connection.useMaxRows()) {
                this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, this.currentCatalog);
            }
            boolean oldInfoMsgState = false;
            if (this.retrieveGeneratedKeys) {
                oldInfoMsgState = this.connection.isReadInfoMsgEnabled();
                this.connection.setReadInfoMsgEnabled(true);
            }
            rs = this.connection.execSQL(null, -1, sendPacket, this.resultSetConcurrency, false, false, this.currentCatalog);
            if (this.retrieveGeneratedKeys) {
                this.connection.setReadInfoMsgEnabled(oldInfoMsgState);
            }
            if (oldCatalog != null) {
                this.connection.setCatalog(oldCatalog);
            }
        }
        this.results = rs;
        rs.setFirstCharOfQuery(this.firstCharOfStmt);
        this.updateCount = rs.getUpdateCount();
        int truncatedUpdateCount = 0;
        truncatedUpdateCount = this.updateCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.updateCount;
        this.lastInsertId = rs.getUpdateID();
        this.results = rs;
        return truncatedUpdateCount;
    }

    byte[] getBytes(int parameterIndex) throws SQLException {
        if (this.isStream[parameterIndex]) {
            return this.streamToBytes(this.parameterStreams[parameterIndex], false, this.streamLengths[parameterIndex], this.connection.useStreamLengthsInPrepStmts());
        }
        byte[] parameterVal = this.parameterValues[parameterIndex];
        if (parameterVal == null) {
            return null;
        }
        if (parameterVal[0] == 39 && parameterVal[parameterVal.length - 1] == 39) {
            byte[] valNoQuotes = new byte[parameterVal.length - 2];
            System.arraycopy(parameterVal, 1, valNoQuotes, 0, parameterVal.length - 2);
            return valNoQuotes;
        }
        return parameterVal;
    }

    boolean isNull(int paramIndex) {
        return this.isNull[paramIndex];
    }

    ParseInfo getParseInfo() {
        return this.parseInfo;
    }

    void setResultSetConcurrency(int concurrencyFlag) {
        this.resultSetConcurrency = concurrencyFlag;
    }

    void setResultSetType(int typeFlag) {
        this.resultSetType = typeFlag;
    }

    private final String getDateTimePattern(String dt, boolean toTime) throws Exception {
        int i2;
        int size;
        char c2;
        int n2;
        Object[] v2;
        int z2;
        char c3;
        int dtLength;
        int n3 = dtLength = dt != null ? dt.length() : 0;
        if (dtLength >= 8 && dtLength <= 10) {
            int dashCount = 0;
            boolean isDateOnly = true;
            int i3 = 0;
            while (i3 < dtLength) {
                c3 = dt.charAt(i3);
                if (!Character.isDigit(c3) && c3 != '-') {
                    isDateOnly = false;
                    break;
                }
                if (c3 == '-') {
                    ++dashCount;
                }
                ++i3;
            }
            if (isDateOnly && dashCount == 2) {
                return "yyyy-MM-dd";
            }
        }
        boolean colonsOnly = true;
        int i4 = 0;
        while (i4 < dtLength) {
            char c4 = dt.charAt(i4);
            if (!Character.isDigit(c4) && c4 != ':') {
                colonsOnly = false;
                break;
            }
            ++i4;
        }
        if (colonsOnly) {
            return "HH:mm:ss";
        }
        StringReader reader = new StringReader(dt + " ");
        ArrayList<Object[]> vec = new ArrayList<Object[]>();
        ArrayList<Object[]> vecRemovelist = new ArrayList<Object[]>();
        Object[] nv = new Object[]{new Character('y'), new StringBuffer(), new Integer(0)};
        vec.add(nv);
        if (toTime) {
            nv = new Object[]{new Character('h'), new StringBuffer(), new Integer(0)};
            vec.add(nv);
        }
        while ((z2 = reader.read()) != -1) {
            char separator = c3;
            int maxvecs = vec.size();
            int count = 0;
            while (count < maxvecs) {
                v2 = (Object[])vec.get(count);
                n2 = (Integer)v2[2];
                c2 = this.getSuccessor(((Character)v2[0]).charValue(), n2);
                if (!Character.isLetterOrDigit(separator)) {
                    if (c2 == ((Character)v2[0]).charValue() && c2 != 'S') {
                        vecRemovelist.add(v2);
                    } else {
                        ((StringBuffer)v2[1]).append(separator);
                        if (c2 == 'X' || c2 == 'Y') {
                            v2[2] = new Integer(4);
                        }
                    }
                } else {
                    if (c2 == 'X') {
                        c2 = 'y';
                        nv = new Object[3];
                        nv[1] = new StringBuffer(((StringBuffer)v2[1]).toString()).append('M');
                        nv[0] = new Character('M');
                        nv[2] = new Integer(1);
                        vec.add(nv);
                    } else if (c2 == 'Y') {
                        c2 = 'M';
                        nv = new Object[3];
                        nv[1] = new StringBuffer(((StringBuffer)v2[1]).toString()).append('d');
                        nv[0] = new Character('d');
                        nv[2] = new Integer(1);
                        vec.add(nv);
                    }
                    ((StringBuffer)v2[1]).append(c2);
                    if (c2 == ((Character)v2[0]).charValue()) {
                        v2[2] = new Integer(n2 + 1);
                    } else {
                        v2[0] = new Character(c2);
                        v2[2] = new Integer(1);
                    }
                }
                ++count;
            }
            size = vecRemovelist.size();
            i2 = 0;
            while (i2 < size) {
                v2 = (Object[])vecRemovelist.get(i2);
                vec.remove(v2);
                ++i2;
            }
            vecRemovelist.clear();
        }
        size = vec.size();
        i2 = 0;
        while (i2 < size) {
            boolean containsEnd;
            v2 = (Object[])vec.get(i2);
            c2 = ((Character)v2[0]).charValue();
            boolean bk = this.getSuccessor(c2, n2 = ((Integer)v2[2]).intValue()) != c2;
            boolean atEnd = (c2 == 's' || c2 == 'm' || c2 == 'h' && toTime) && bk;
            boolean finishesAtDate = bk && c2 == 'd' && !toTime;
            boolean bl = containsEnd = ((StringBuffer)v2[1]).toString().indexOf(87) != -1;
            if (!atEnd && !finishesAtDate || containsEnd) {
                vecRemovelist.add(v2);
            }
            ++i2;
        }
        size = vecRemovelist.size();
        int i5 = 0;
        while (i5 < size) {
            vec.remove(vecRemovelist.get(i5));
            ++i5;
        }
        vecRemovelist.clear();
        v2 = (Object[])vec.get(0);
        StringBuffer format = (StringBuffer)v2[1];
        format.setLength(format.length() - 1);
        return format.toString();
    }

    private final void setInternal(int paramIndex, byte[] val) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("PreparedStatement has been closed. No further operations allowed.", "S1009");
        }
        if (paramIndex < 1) {
            throw new SQLException("Parameter index out of range (" + paramIndex + " < 1 ).", "S1009");
        }
        if (paramIndex >= this.staticSqlStrings.length) {
            throw new SQLException("Parameter index out of range (" + paramIndex + " > " + (this.staticSqlStrings.length - 1) + ").", "S1009");
        }
        this.isStream[paramIndex - 1] = false;
        this.isNull[paramIndex - 1] = false;
        this.parameterStreams[paramIndex - 1] = null;
        this.parameterValues[paramIndex - 1] = val;
    }

    private final void setInternal(int paramIndex, String val) throws SQLException {
        byte[] parameterAsBytes = null;
        if (this.charConverter != null) {
            parameterAsBytes = this.charConverter.toBytes(val);
        } else {
            try {
                parameterAsBytes = StringUtils.getBytes(val, this.charConverter, this.charEncoding, this.connection.parserKnowsUnicode());
            }
            catch (UnsupportedEncodingException uEE) {
                throw new SQLException("Unsupported encoding '" + this.charEncoding + "'", "S1009");
            }
        }
        this.setInternal(paramIndex, parameterAsBytes);
    }

    private final void setSerializableObject(int parameterIndex, Object parameterObj) throws SQLException {
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(bytesOut);
            objectOut.writeObject(parameterObj);
            objectOut.flush();
            objectOut.close();
            bytesOut.flush();
            bytesOut.close();
            byte[] buf = bytesOut.toByteArray();
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(buf);
            this.setBinaryStream(parameterIndex, (InputStream)bytesIn, buf.length);
        }
        catch (Exception ex) {
            throw new SQLException("Invalid argument value: " + ex.getClass().getName(), "S1009");
        }
    }

    private final char getSuccessor(char c2, int n2) {
        return (char)(c2 == 'y' && n2 == 2 ? 88 : (c2 == 'y' && n2 < 4 ? 121 : (c2 == 'y' ? 77 : (c2 == 'M' && n2 == 2 ? 89 : (c2 == 'M' && n2 < 3 ? 77 : (c2 == 'M' ? 100 : (c2 == 'd' && n2 < 2 ? 100 : (c2 == 'd' ? 72 : (c2 == 'H' && n2 < 2 ? 72 : (c2 == 'H' ? 109 : (c2 == 'm' && n2 < 2 ? 109 : (c2 == 'm' ? 115 : (c2 == 's' && n2 < 2 ? 115 : 87)))))))))))));
    }

    private void setTimeInternal(int parameterIndex, Time x2, TimeZone tz) throws SQLException {
        if (x2 == null) {
            this.setNull(parameterIndex, 92);
        } else {
            x2 = TimeUtil.changeTimezone(this.connection, x2, tz, this.connection.getServerTimezone());
            this.setInternal(parameterIndex, "'" + x2.toString() + "'");
        }
    }

    private synchronized void setTimestampInternal(int parameterIndex, Timestamp x2, TimeZone tz) throws SQLException {
        if (x2 == null) {
            this.setNull(parameterIndex, 93);
        } else {
            String timestampString = null;
            x2 = TimeUtil.changeTimezone(this.connection, x2, tz, this.connection.getServerTimezone());
            if (this.tsdf == null) {
                this.tsdf = new SimpleDateFormat("''yyyy-MM-dd HH:mm:ss''");
            }
            timestampString = this.tsdf.format(x2);
            this.setInternal(parameterIndex, timestampString);
        }
    }

    private final void escapeblockFast(byte[] buf, ByteArrayOutputStream bytesOut, int size) {
        int lastwritten = 0;
        int i2 = 0;
        while (i2 < size) {
            byte b2 = buf[i2];
            if (b2 == 0) {
                if (i2 > lastwritten) {
                    bytesOut.write(buf, lastwritten, i2 - lastwritten);
                }
                bytesOut.write(92);
                bytesOut.write(48);
                lastwritten = i2 + 1;
            } else if (b2 == 92 || b2 == 39 || b2 == 34) {
                if (i2 > lastwritten) {
                    bytesOut.write(buf, lastwritten, i2 - lastwritten);
                }
                bytesOut.write(92);
                lastwritten = i2;
            }
            ++i2;
        }
        if (lastwritten < size) {
            bytesOut.write(buf, lastwritten, size - lastwritten);
        }
    }

    private final void escapeblockFast(byte[] buf, Buffer packet, int size) throws SQLException {
        int lastwritten = 0;
        int i2 = 0;
        while (i2 < size) {
            byte b2 = buf[i2];
            if (b2 == 0) {
                if (i2 > lastwritten) {
                    packet.writeBytesNoNull(buf, lastwritten, i2 - lastwritten);
                }
                packet.writeByte((byte)92);
                packet.writeByte((byte)48);
                lastwritten = i2 + 1;
            } else if (b2 == 92 || b2 == 39 || b2 == 34) {
                if (i2 > lastwritten) {
                    packet.writeBytesNoNull(buf, lastwritten, i2 - lastwritten);
                }
                packet.writeByte((byte)92);
                lastwritten = i2;
            }
            ++i2;
        }
        if (lastwritten < size) {
            packet.writeBytesNoNull(buf, lastwritten, size - lastwritten);
        }
    }

    private Buffer fillSendPacket() throws SQLException {
        return this.fillSendPacket(this.parameterValues, this.parameterStreams, this.isStream, this.streamLengths);
    }

    private Buffer fillSendPacket(byte[][] batchedParameterStrings, InputStream[] batchedParameterStreams, boolean[] batchedIsStream, int[] batchedStreamLengths) throws SQLException {
        Buffer sendPacket = this.connection.getIO().getSharedSendPacket();
        sendPacket.clear();
        sendPacket.writeByte((byte)3);
        boolean useStreamLengths = this.connection.useStreamLengthsInPrepStmts();
        int ensurePacketSize = 0;
        int i2 = 0;
        while (i2 < batchedParameterStrings.length) {
            if (batchedIsStream[i2] && useStreamLengths) {
                ensurePacketSize += batchedStreamLengths[i2];
            }
            ++i2;
        }
        if (ensurePacketSize != 0) {
            sendPacket.ensureCapacity(ensurePacketSize);
        }
        int i3 = 0;
        while (i3 < batchedParameterStrings.length) {
            if (batchedParameterStrings[i3] == null && batchedParameterStreams[i3] == null) {
                throw new SQLException("No value specified for parameter " + (i3 + 1), "07001");
            }
            sendPacket.writeBytesNoNull(this.staticSqlStrings[i3]);
            if (batchedIsStream[i3]) {
                this.streamToBytes(sendPacket, batchedParameterStreams[i3], true, batchedStreamLengths[i3], useStreamLengths);
            } else {
                sendPacket.writeBytesNoNull(batchedParameterStrings[i3]);
            }
            ++i3;
        }
        sendPacket.writeBytesNoNull(this.staticSqlStrings[batchedParameterStrings.length]);
        return sendPacket;
    }

    private static final String fixDecimalExponent(String dString) {
        char maybeMinusChar;
        int ePos = dString.indexOf("E");
        if (ePos == -1) {
            ePos = dString.indexOf("e");
        }
        if (ePos != -1 && dString.length() > ePos + 1 && (maybeMinusChar = dString.charAt(ePos + 1)) != '-') {
            StringBuffer buf = new StringBuffer(dString.length() + 1);
            buf.append(dString.substring(0, ePos + 1));
            buf.append('+');
            buf.append(dString.substring(ePos + 1, dString.length()));
            dString = buf.toString();
        }
        return dString;
    }

    private void initializeFromParseInfo() throws SQLException {
        this.staticSqlStrings = this.parseInfo.staticSql;
        this.hasLimitClause = this.parseInfo.foundLimitClause;
        this.isLoadDataQuery = this.parseInfo.foundLoadData;
        this.firstCharOfStmt = this.parseInfo.firstStmtChar;
        int numberOfParameters = this.staticSqlStrings.length - 1;
        this.parameterValues = new byte[numberOfParameters][];
        this.parameterStreams = new InputStream[numberOfParameters];
        this.isStream = new boolean[numberOfParameters];
        this.streamLengths = new int[numberOfParameters];
        this.isNull = new boolean[numberOfParameters];
        this.clearParameters();
        int j2 = 0;
        while (j2 < numberOfParameters) {
            this.isStream[j2] = false;
            ++j2;
        }
    }

    private final int readblock(InputStream i2, byte[] b2, int length) throws SQLException {
        try {
            int lengthToRead = length;
            if (lengthToRead > b2.length) {
                lengthToRead = b2.length;
            }
            return i2.read(b2, 0, lengthToRead);
        }
        catch (Throwable E) {
            throw new SQLException("Error reading from InputStream " + E.getClass().getName(), "S1000");
        }
    }

    private final int readblock(InputStream i2, byte[] b2) throws SQLException {
        try {
            return i2.read(b2);
        }
        catch (Throwable E) {
            throw new SQLException("Error reading from InputStream " + E.getClass().getName(), "S1000");
        }
    }

    private final byte[] streamToBytes(InputStream in, int streamLength, boolean useLength) throws SQLException {
        return this.streamToBytes(in, true, streamLength, useLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] streamToBytes(InputStream in, boolean escape, int streamLength, boolean useLength) throws SQLException {
        byte[] byArray;
        try {
            if (streamLength == -1) {
                useLength = false;
            }
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            int bc = -1;
            bc = useLength ? this.readblock(in, this.streamConvertBuf, streamLength) : this.readblock(in, this.streamConvertBuf);
            int lengthLeftToRead = streamLength - bc;
            if (escape) {
                bytesOut.write(39);
            }
            while (bc > 0) {
                if (escape) {
                    this.escapeblockFast(this.streamConvertBuf, bytesOut, bc);
                } else {
                    bytesOut.write(this.streamConvertBuf, 0, bc);
                }
                if (useLength) {
                    bc = this.readblock(in, this.streamConvertBuf, lengthLeftToRead);
                    if (bc <= 0) continue;
                    lengthLeftToRead -= bc;
                    continue;
                }
                bc = this.readblock(in, this.streamConvertBuf);
            }
            if (escape) {
                bytesOut.write(39);
            }
            byArray = bytesOut.toByteArray();
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                in.close();
            }
            catch (IOException ioEx) {
                // empty catch block
            }
            in = null;
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException ioEx) {
            // empty catch block
        }
        in = null;
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void streamToBytes(Buffer packet, InputStream in, boolean escape, int streamLength, boolean useLength) throws SQLException {
        block12: {
            try {
                if (streamLength == -1) {
                    useLength = false;
                }
                int bc = -1;
                bc = useLength ? this.readblock(in, this.streamConvertBuf, streamLength) : this.readblock(in, this.streamConvertBuf);
                int lengthLeftToRead = streamLength - bc;
                if (escape) {
                    packet.writeByte((byte)39);
                }
                while (bc > 0) {
                    if (escape) {
                        this.escapeblockFast(this.streamConvertBuf, packet, bc);
                    } else {
                        packet.writeBytesNoNull(this.streamConvertBuf, 0, bc);
                    }
                    if (useLength) {
                        bc = this.readblock(in, this.streamConvertBuf, lengthLeftToRead);
                        if (bc <= 0) continue;
                        lengthLeftToRead -= bc;
                        continue;
                    }
                    bc = this.readblock(in, this.streamConvertBuf);
                }
                if (escape) {
                    packet.writeByte((byte)39);
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    in.close();
                }
                catch (IOException ioEx) {
                    // empty catch block
                }
                in = null;
                throw throwable;
            }
            try {
                in.close();
                break block12;
            }
            catch (IOException ioEx) {
                // empty catch block
            }
            {
            }
        }
        in = null;
    }

    private static int readFully(Reader reader, char[] buf, int length) throws IOException {
        int numCharsRead = 0;
        while (numCharsRead < length) {
            int count = reader.read(buf, numCharsRead, length - numCharsRead);
            if (count < 0) break;
            numCharsRead += count;
        }
        return numCharsRead;
    }

    class ParseInfo {
        byte[][] staticSql = null;
        boolean foundLimitClause = false;
        boolean foundLoadData = false;
        char firstStmtChar = '\u0000';
        int statementLength = 0;
        long lastUsed = 0L;

        public ParseInfo(String sql, Connection conn, DatabaseMetaData dbmd, String encoding, SingleByteCharsetConverter converter) throws SQLException {
            if (sql == null) {
                throw new SQLException("SQL String can not be NULL", "S1009");
            }
            this.lastUsed = System.currentTimeMillis();
            String quotedIdentifierString = dbmd.getIdentifierQuoteString();
            char quotedIdentifierChar = '\u0000';
            if (quotedIdentifierString != null && !quotedIdentifierString.equals(" ") && quotedIdentifierString.length() > 0) {
                quotedIdentifierChar = quotedIdentifierString.charAt(0);
            }
            this.statementLength = sql.length();
            ArrayList<int[]> endpointList = new ArrayList<int[]>();
            boolean inQuotes = false;
            boolean inQuotedId = false;
            int lastParmEnd = 0;
            int pre1 = 0;
            int pre2 = 0;
            int lastAlphaCharPos = 0;
            int stopLookingForLimitClause = this.statementLength - 5;
            this.foundLimitClause = false;
            int i2 = 0;
            while (i2 < this.statementLength) {
                char posT;
                char posI2;
                char posM;
                char posI1;
                char c2 = sql.charAt(i2);
                if (this.firstStmtChar == '\u0000' && !Character.isWhitespace(c2)) {
                    this.firstStmtChar = Character.toUpperCase(c2);
                }
                if (Character.isLetter(c2)) {
                    lastAlphaCharPos = i2;
                }
                if (!inQuotes && quotedIdentifierChar != '\u0000' && c2 == quotedIdentifierChar) {
                    boolean bl = inQuotedId = !inQuotedId;
                }
                if (!inQuotedId) {
                    if (c2 == '\'' && pre1 == 92 && pre2 == 92) {
                        inQuotes = !inQuotes;
                    } else if (c2 == '\'' && pre1 != 92) {
                        boolean bl = inQuotes = !inQuotes;
                    }
                }
                if (c2 == '?' && !inQuotes) {
                    endpointList.add(new int[]{lastParmEnd, i2});
                    lastParmEnd = i2 + 1;
                }
                if (!(inQuotes || i2 >= stopLookingForLimitClause || c2 != 'L' && c2 != 'l' || (posI1 = sql.charAt(i2 + 1)) != 'I' && posI1 != 'i' || (posM = sql.charAt(i2 + 2)) != 'M' && posM != 'm' || (posI2 = sql.charAt(i2 + 3)) != 'I' && posI2 != 'i' || (posT = sql.charAt(i2 + 4)) != 'T' && posT != 't')) {
                    this.foundLimitClause = true;
                }
                pre2 = pre1;
                pre1 = c2;
                ++i2;
            }
            this.foundLoadData = this.firstStmtChar == 'L' ? StringUtils.startsWithIgnoreCaseAndWs(sql, "LOAD DATA") : false;
            endpointList.add(new int[]{lastParmEnd, this.statementLength});
            this.staticSql = new byte[endpointList.size()][];
            i2 = 0;
            while (i2 < this.staticSql.length) {
                int[] ep = (int[])endpointList.get(i2);
                int end = ep[1];
                int begin = ep[0];
                int len = end - begin;
                if (this.foundLoadData) {
                    String temp = new String(sql.toCharArray(), begin, len);
                    this.staticSql[i2] = temp.getBytes();
                } else if (encoding == null) {
                    byte[] buf = new byte[len];
                    int j2 = 0;
                    while (j2 < len) {
                        buf[j2] = (byte)sql.charAt(begin + j2);
                        ++j2;
                    }
                    this.staticSql[i2] = buf;
                } else {
                    try {
                        if (converter != null) {
                            this.staticSql[i2] = StringUtils.getBytes(sql, converter, encoding, begin, len, PreparedStatement.this.connection.parserKnowsUnicode());
                        } else {
                            String temp = new String(sql.toCharArray(), begin, len);
                            this.staticSql[i2] = StringUtils.getBytes(temp, null, encoding, PreparedStatement.this.connection.parserKnowsUnicode());
                        }
                    }
                    catch (UnsupportedEncodingException ue) {
                        throw new SQLException(ue.toString());
                    }
                }
                ++i2;
            }
            int numberOfParameters = this.staticSql.length - 1;
        }
    }

    class BatchParams {
        boolean[] isNull = null;
        boolean[] isStream = null;
        InputStream[] parameterStreams = null;
        byte[][] parameterStrings = null;
        int[] streamLengths = null;

        BatchParams(byte[][] strings, InputStream[] streams, boolean[] isStreamFlags, int[] lengths, boolean[] isNullFlags) {
            this.parameterStrings = new byte[strings.length][];
            this.parameterStreams = new InputStream[streams.length];
            this.isStream = new boolean[isStreamFlags.length];
            this.streamLengths = new int[lengths.length];
            this.isNull = new boolean[isNullFlags.length];
            System.arraycopy(strings, 0, this.parameterStrings, 0, strings.length);
            System.arraycopy(streams, 0, this.parameterStreams, 0, streams.length);
            System.arraycopy(isStreamFlags, 0, this.isStream, 0, isStreamFlags.length);
            System.arraycopy(lengths, 0, this.streamLengths, 0, lengths.length);
            System.arraycopy(isNullFlags, 0, this.isNull, 0, isNullFlags.length);
        }
    }
}

