/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.CharsetMapping;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class SingleByteCharsetConverter {
    private static byte[] unknownCharsMap = new byte[65536];
    private static final int BYTE_RANGE = 256;
    private static final Map CONVERTER_MAP;
    private static byte[] allBytes;
    private char[] byteToChars = new char[256];
    private byte[] charToByteMap = new byte[65536];
    private static final byte[] EMPTY_BYTE_ARRAY;

    private SingleByteCharsetConverter(String encodingName) throws UnsupportedEncodingException {
        String allBytesString = new String(allBytes, 0, 256, encodingName);
        int allBytesLen = allBytesString.length();
        System.arraycopy(unknownCharsMap, 0, this.charToByteMap, 0, this.charToByteMap.length);
        int i2 = 0;
        while (i2 < 256 && i2 < allBytesLen) {
            char c2;
            this.byteToChars[i2] = c2 = allBytesString.charAt(i2);
            this.charToByteMap[c2] = allBytes[i2];
            ++i2;
        }
    }

    public static synchronized SingleByteCharsetConverter getInstance(String encodingName) throws UnsupportedEncodingException {
        SingleByteCharsetConverter instance = (SingleByteCharsetConverter)CONVERTER_MAP.get(encodingName);
        if (instance == null) {
            instance = SingleByteCharsetConverter.initCharset(encodingName);
        }
        return instance;
    }

    public static SingleByteCharsetConverter initCharset(String javaEncodingName) throws UnsupportedEncodingException {
        String mysqlEncodingName = (String)CharsetMapping.JAVA_TO_MYSQL_CHARSET_MAP.get(javaEncodingName);
        if (mysqlEncodingName == null) {
            return null;
        }
        if (CharsetMapping.MULTIBYTE_CHARSETS.containsKey(mysqlEncodingName)) {
            return null;
        }
        SingleByteCharsetConverter converter = new SingleByteCharsetConverter(javaEncodingName);
        CONVERTER_MAP.put(javaEncodingName, converter);
        return converter;
    }

    public static String toStringDefaultEncoding(byte[] buffer, int startPos, int length) {
        return new String(buffer, startPos, length);
    }

    public final byte[] toBytes(String s2) {
        if (s2 == null) {
            return null;
        }
        int length = s2.length();
        byte[] bytes = new byte[length];
        int i2 = 0;
        while (i2 < length) {
            char c2 = s2.charAt(i2);
            bytes[i2] = this.charToByteMap[c2];
            ++i2;
        }
        return bytes;
    }

    public final byte[] toBytes(String s2, int offset, int length) {
        if (s2 == null) {
            return null;
        }
        if (length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        int stringLength = s2.length();
        byte[] bytes = new byte[length];
        int i2 = 0;
        while (i2 < length) {
            char c2 = s2.charAt(i2 + offset);
            bytes[i2] = this.charToByteMap[c2];
            ++i2;
        }
        return bytes;
    }

    public final String toString(byte[] buffer) {
        return this.toString(buffer, 0, buffer.length);
    }

    public final String toString(byte[] buffer, int startPos, int length) {
        char[] charArray = new char[length];
        int readpoint = startPos;
        int i2 = 0;
        while (i2 < length) {
            charArray[i2] = this.byteToChars[buffer[readpoint] - -128];
            ++readpoint;
            ++i2;
        }
        return new String(charArray);
    }

    static {
        BYTE_RANGE = 256;
        CONVERTER_MAP = new HashMap();
        allBytes = new byte[256];
        int i2 = -128;
        while (i2 <= 127) {
            SingleByteCharsetConverter.allBytes[i2 - -128] = (byte)i2;
            ++i2;
        }
        int i3 = 0;
        while (i3 < unknownCharsMap.length) {
            SingleByteCharsetConverter.unknownCharsMap[i3] = 63;
            ++i3;
        }
        EMPTY_BYTE_ARRAY = new byte[0];
    }
}

