/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.DerInputBuffer;
import com.sun.net.ssl.internal.ssl.DerInputStream;
import com.sun.net.ssl.internal.ssl.DerOutputStream;
import java.io.IOException;
import java.io.Serializable;

final class ObjectIdentifier
implements Serializable {
    private static final long serialVersionUID = 8697030238860181294L;
    private int[] a;
    private int b;
    private static final int c = 5;

    ObjectIdentifier(DerInputBuffer derInputBuffer) throws IOException {
        this.a(new DerInputStream(derInputBuffer), 0);
    }

    public ObjectIdentifier(DerInputStream derInputStream) throws IOException {
        byte by = (byte)derInputStream.a();
        if (by != 6) {
            throw new IOException("X509.ObjectIdentifier() -- data isn't an object ID (tag = " + by + ")");
        }
        int n2 = derInputStream.available() - derInputStream.b() - 1;
        if (n2 < 0) {
            throw new IOException("X509.ObjectIdentifier() -- not enough data");
        }
        this.a(derInputStream, n2);
    }

    public ObjectIdentifier(String string) {
        int n2 = 46;
        int n3 = 0;
        int n4 = 0;
        this.b = 0;
        while ((n4 = string.indexOf(n2, n3)) != -1) {
            n3 = n4 + 1;
            ++this.b;
        }
        ++this.b;
        this.a = new int[this.b];
        n3 = 0;
        int n5 = 0;
        String string2 = null;
        while ((n4 = string.indexOf(n2, n3)) != -1) {
            string2 = string.substring(n3, n4);
            this.a[n5++] = Integer.valueOf(string2);
            n3 = n4 + 1;
        }
        string2 = string.substring(n3);
        this.a[n5] = Integer.valueOf(string2);
    }

    public ObjectIdentifier(int[] nArray) {
        try {
            this.a = (int[])nArray.clone();
            this.b = nArray.length;
        }
        catch (Throwable throwable) {
            System.out.println("X509.ObjectIdentifier(), no cloning!");
        }
    }

    void a(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(this.a[0] * 40 + this.a[1]);
        int n2 = 2;
        while (n2 < this.b) {
            ObjectIdentifier.a(derOutputStream2, this.a[n2]);
            ++n2;
        }
        derOutputStream.write((byte)6, derOutputStream2);
    }

    public boolean equals(ObjectIdentifier objectIdentifier) {
        if (objectIdentifier == this) {
            return true;
        }
        if (this.b != objectIdentifier.b) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.b) {
            if (this.a[n2] != objectIdentifier.a[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof ObjectIdentifier) {
            return this.equals((ObjectIdentifier)object);
        }
        return false;
    }

    private static int a(DerInputStream derInputStream) throws IOException {
        int n2 = 0;
        int n3 = 0;
        while (n2 < 4) {
            n3 <<= 7;
            int n4 = derInputStream.a();
            n3 |= n4 & 0x7F;
            if ((n4 & 0x80) == 0) {
                return n3;
            }
            ++n2;
        }
        throw new IOException("X509.OID, component value too big");
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private void a(DerInputStream derInputStream, int n2) throws IOException {
        boolean bl = true;
        this.a = new int[5];
        this.b = 0;
        while (derInputStream.available() > n2) {
            int n3 = ObjectIdentifier.a(derInputStream);
            if (bl) {
                int n4 = n3 < 40 ? 0 : (n3 < 80 ? 1 : 2);
                int n5 = n3 - n4 * 40;
                this.a[0] = n4;
                this.a[1] = n5;
                this.b = 2;
                bl = false;
                continue;
            }
            if (this.b >= this.a.length) {
                int[] nArray = new int[this.a.length + 5];
                System.arraycopy(this.a, 0, nArray, 0, this.a.length);
                this.a = nArray;
            }
            this.a[this.b++] = n3;
        }
        if (derInputStream.available() != n2) {
            throw new IOException("X509.ObjectIdentifier() -- malformed input data");
        }
    }

    public boolean precedes(ObjectIdentifier objectIdentifier) {
        if (objectIdentifier == this || this.b < objectIdentifier.b) {
            return false;
        }
        if (objectIdentifier.b < this.b) {
            return true;
        }
        int n2 = 0;
        while (n2 < this.b) {
            if (objectIdentifier.a[n2] < this.a[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void a(DerOutputStream derOutputStream, int n2) throws IOException {
        byte[] byArray = new byte[4];
        int n3 = 0;
        while (n3 < 4) {
            byArray[n3] = (byte)(n2 & 0x7F);
            if ((n2 >>>= 7) == 0) break;
            ++n3;
        }
        while (n3 > 0) {
            derOutputStream.write(byArray[n3] | 0x80);
            --n3;
        }
        derOutputStream.write(byArray[0]);
    }

    public String toString() {
        int n2 = 0;
        String string = "";
        while (n2 < this.b) {
            if (n2 != 0) {
                string = String.valueOf(string) + ".";
            }
            string = String.valueOf(string) + this.a[n2];
            ++n2;
        }
        return string;
    }
}

