/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.AlreadyExists;
import com.vmware.vim25.ClusterConfigSpec;
import com.vmware.vim25.ClusterConfigSpecEx;
import com.vmware.vim25.ComputeResourceConfigSpec;
import com.vmware.vim25.ConcurrentAccess;
import com.vmware.vim25.DVSCreateSpec;
import com.vmware.vim25.DuplicateName;
import com.vmware.vim25.DvsFault;
import com.vmware.vim25.DvsNotAuthorized;
import com.vmware.vim25.FileFault;
import com.vmware.vim25.HostConnectFault;
import com.vmware.vim25.HostConnectSpec;
import com.vmware.vim25.InsufficientResourcesFault;
import com.vmware.vim25.InvalidDatastore;
import com.vmware.vim25.InvalidFolder;
import com.vmware.vim25.InvalidLogin;
import com.vmware.vim25.InvalidName;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFound;
import com.vmware.vim25.OutOfBounds;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.VmConfigFault;
import com.vmware.vim25.mo.ClusterComputeResource;
import com.vmware.vim25.mo.Datacenter;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ResourcePool;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.StoragePod;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.util.MorUtil;
import java.rmi.RemoteException;

public class Folder
extends ManagedEntity {
    public Folder(ServerConnection sc, ManagedObjectReference mor) {
        super(sc, mor);
    }

    public ManagedEntity[] getChildEntity() throws InvalidProperty, RuntimeFault, RemoteException {
        ManagedObjectReference[] mors = (ManagedObjectReference[])this.getCurrentProperty("childEntity");
        if (mors == null) {
            return new ManagedEntity[0];
        }
        ManagedEntity[] mes = new ManagedEntity[mors.length];
        for (int i2 = 0; i2 < mors.length; ++i2) {
            mes[i2] = MorUtil.createExactManagedEntity(this.getServerConnection(), mors[i2]);
        }
        return mes;
    }

    public String[] getChildType() {
        return (String[])this.getCurrentProperty("childType");
    }

    public Task addStandaloneHost_Task(HostConnectSpec spec, ComputeResourceConfigSpec compResSpec, boolean addConnected) throws InvalidLogin, HostConnectFault, RuntimeFault, RemoteException {
        return this.addStandaloneHost_Task(spec, compResSpec, addConnected, null);
    }

    public Task addStandaloneHost_Task(HostConnectSpec spec, ComputeResourceConfigSpec compResSpec, boolean addConnected, String license) throws InvalidLogin, HostConnectFault, RuntimeFault, RemoteException {
        return new Task(this.getServerConnection(), this.getVimService().addStandaloneHost_Task(this.getMOR(), spec, compResSpec, addConnected, license));
    }

    public ClusterComputeResource createCluster(String name, ClusterConfigSpec spec) throws InvalidName, DuplicateName, RuntimeFault, RemoteException {
        return new ClusterComputeResource(this.getServerConnection(), this.getVimService().createCluster(this.getMOR(), name, spec));
    }

    public ClusterComputeResource createClusterEx(String name, ClusterConfigSpecEx spec) throws InvalidName, DuplicateName, RuntimeFault, RemoteException {
        return new ClusterComputeResource(this.getServerConnection(), this.getVimService().createClusterEx(this.getMOR(), name, spec));
    }

    public Datacenter createDatacenter(String name) throws InvalidName, DuplicateName, RuntimeFault, RemoteException {
        return new Datacenter(this.getServerConnection(), this.getVimService().createDatacenter(this.getMOR(), name));
    }

    public Task createDVS_Task(DVSCreateSpec spec) throws DvsNotAuthorized, DvsFault, DuplicateName, InvalidName, NotFound, RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().createDVS_Task(this.getMOR(), spec);
        return new Task(this.getServerConnection(), taskMor);
    }

    public Folder createFolder(String name) throws InvalidName, DuplicateName, RuntimeFault, RemoteException {
        return new Folder(this.getServerConnection(), this.getVimService().createFolder(this.getMOR(), name));
    }

    public StoragePod createStoragePod(String name) throws DuplicateName, InvalidName, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().createStoragePod(this.getMOR(), name);
        return new StoragePod(this.getServerConnection(), mor);
    }

    public Task createVM_Task(VirtualMachineConfigSpec config, ResourcePool pool, HostSystem host) throws InvalidName, VmConfigFault, DuplicateName, FileFault, OutOfBounds, InsufficientResourcesFault, InvalidDatastore, RuntimeFault, RemoteException {
        return new Task(this.getServerConnection(), this.getVimService().createVM_Task(this.getMOR(), config, pool.getMOR(), host == null ? null : host.getMOR()));
    }

    public Task moveIntoFolder_Task(ManagedEntity[] entities) throws DuplicateName, InvalidState, InvalidFolder, RuntimeFault, RemoteException {
        if (entities == null) {
            throw new IllegalArgumentException("entities must not be null");
        }
        return new Task(this.getServerConnection(), this.getVimService().moveIntoFolder_Task(this.getMOR(), MorUtil.createMORs(entities)));
    }

    public Task registerVM_Task(String path, String name, boolean asTemplate, ResourcePool pool, HostSystem host) throws VmConfigFault, InvalidName, DuplicateName, FileFault, OutOfBounds, InsufficientResourcesFault, InvalidDatastore, AlreadyExists, NotFound, RuntimeFault, RemoteException {
        return new Task(this.getServerConnection(), this.getVimService().registerVM_Task(this.getMOR(), path, name, asTemplate, pool == null ? null : pool.getMOR(), host == null ? null : host.getMOR()));
    }

    public Task unregisterAndDestroy_Task() throws InvalidState, ConcurrentAccess, RuntimeFault, RemoteException {
        return new Task(this.getServerConnection(), this.getVimService().unregisterAndDestroy_Task(this.getMOR()));
    }
}

