/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.InvalidDatastore;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.Datacenter;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.util.MorUtil;
import java.rmi.RemoteException;

public class SearchIndex
extends ManagedObject {
    public SearchIndex(ServerConnection serverConnection, ManagedObjectReference mor) {
        super(serverConnection, mor);
    }

    public ManagedEntity findByInventoryPath(String inventoryPath) throws RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().findByInventoryPath(this.getMOR(), inventoryPath);
        return MorUtil.createExactManagedEntity(this.getServerConnection(), mor);
    }

    public ManagedEntity findByIp(Datacenter datacenter, String ip, boolean vmOnly) throws RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().findByIp(this.getMOR(), datacenter == null ? null : datacenter.getMOR(), ip, vmOnly);
        return MorUtil.createExactManagedEntity(this.getServerConnection(), mor);
    }

    public ManagedEntity findByDnsName(Datacenter datacenter, String dnsName, boolean vmOnly) throws RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().findByDnsName(this.getMOR(), datacenter == null ? null : datacenter.getMOR(), dnsName, vmOnly);
        return MorUtil.createExactManagedEntity(this.getServerConnection(), mor);
    }

    public ManagedEntity[] findAllByDnsName(Datacenter datacenter, String dnsName, boolean vmSearch) throws RuntimeFault, RemoteException {
        ManagedObjectReference[] mors = this.getVimService().findAllByDnsName(this.getMOR(), datacenter == null ? null : datacenter.getMOR(), dnsName, vmSearch);
        return MorUtil.createManagedEntities(this.getServerConnection(), mors);
    }

    public ManagedEntity[] findAllByIp(Datacenter datacenter, String ip, boolean vmSearch) throws RuntimeFault, RemoteException {
        ManagedObjectReference[] mors = this.getVimService().findAllByIp(this.getMOR(), datacenter == null ? null : datacenter.getMOR(), ip, vmSearch);
        return MorUtil.createManagedEntities(this.getServerConnection(), mors);
    }

    public ManagedEntity[] findAllByUuid(Datacenter datacenter, String uuid, boolean vmSearch, boolean instanceUuid) throws RuntimeFault, RemoteException {
        ManagedObjectReference[] mors = this.getVimService().findAllByUuid(this.getMOR(), datacenter == null ? null : datacenter.getMOR(), uuid, vmSearch, instanceUuid);
        return MorUtil.createManagedEntities(this.getServerConnection(), mors);
    }

    public VirtualMachine findByDatastorePath(Datacenter datacenter, String dPath) throws InvalidDatastore, RuntimeFault, RemoteException {
        if (datacenter == null) {
            throw new IllegalArgumentException("datacenter must not be null.");
        }
        ManagedObjectReference mor = this.getVimService().findByDatastorePath(this.getMOR(), datacenter.getMOR(), dPath);
        return (VirtualMachine)MorUtil.createExactManagedEntity(this.getServerConnection(), mor);
    }

    public ManagedEntity findByUuid(Datacenter datacenter, String uuid, boolean vmOnly) throws RuntimeFault, RemoteException {
        return this.findByUuid(datacenter, uuid, vmOnly, null);
    }

    public ManagedEntity findByUuid(Datacenter datacenter, String uuid, boolean vmOnly, Boolean instanceUuid) throws RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().findByUuid(this.getMOR(), datacenter == null ? null : datacenter.getMOR(), uuid, vmOnly, instanceUuid);
        return MorUtil.createExactManagedEntity(this.getServerConnection(), mor);
    }

    public ManagedEntity findChild(ManagedEntity parent, String name) throws RuntimeFault, RemoteException {
        if (parent == null) {
            throw new IllegalArgumentException("parent entity must not be null.");
        }
        ManagedObjectReference mor = this.getVimService().findChild(this.getMOR(), parent.getMOR(), name);
        return MorUtil.createExactManagedEntity(this.getServerConnection(), mor);
    }
}

