/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import com.sun.activation.registries.MailcapFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;

public class MailcapCommandMap
extends CommandMap {
    private static MailcapFile defDB = null;
    private MailcapFile[] DB = new MailcapFile[5];
    private static final int PROG = 0;
    private static final int HOME = 1;
    private static final int SYS = 2;
    private static final int JAR = 3;
    private static final int DEF = 4;
    private static boolean debug;
    static /* synthetic */ Class class$javax$activation$MailcapCommandMap;

    public MailcapCommandMap() {
        Object object;
        if (debug) {
            System.out.println("MailcapCommandMap: load HOME");
        }
        try {
            object = System.getProperty("user.home");
            if (object != null) {
                String string = String.valueOf(object) + File.separator + ".mailcap";
                this.DB[1] = this.loadFile(string);
            }
        }
        catch (SecurityException securityException) {}
        if (debug) {
            System.out.println("MailcapCommandMap: load SYS");
        }
        try {
            object = String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + "mailcap";
            this.DB[2] = this.loadFile((String)object);
        }
        catch (SecurityException securityException) {}
        if (debug) {
            System.out.println("MailcapCommandMap: load JAR");
        }
        this.DB[3] = this.loadResource("/META-INF/mailcap");
        if (debug) {
            System.out.println("MailcapCommandMap: load DEF");
        }
        object = class$javax$activation$MailcapCommandMap != null ? class$javax$activation$MailcapCommandMap : (class$javax$activation$MailcapCommandMap = CommandMap.class$("javax.activation.MailcapCommandMap"));
        synchronized (object) {
            if (defDB == null) {
                defDB = this.loadResource("/META-INF/mailcap.default");
            }
        }
        this.DB[4] = defDB;
    }

    private MailcapFile loadResource(String string) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream != null) {
                return new MailcapFile(inputStream);
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private MailcapFile loadFile(String string) {
        MailcapFile mailcapFile = null;
        try {
            mailcapFile = new MailcapFile(string);
        }
        catch (IOException iOException) {}
        return mailcapFile;
    }

    public MailcapCommandMap(String string) throws IOException {
        this();
        if (debug) {
            System.out.println("MailcapCommandMap: load PROG from " + string);
        }
        if (this.DB[0] == null) {
            this.DB[0] = new MailcapFile(string);
        }
    }

    public MailcapCommandMap(InputStream inputStream) {
        this();
        if (debug) {
            System.out.println("MailcapCommandMap: load PROG");
        }
        if (this.DB[0] == null) {
            try {
                this.DB[0] = new MailcapFile(inputStream);
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    public synchronized CommandInfo[] getPreferredCommands(String string) {
        Object object;
        Vector vector = new Vector();
        int n2 = 0;
        while (n2 < this.DB.length) {
            if (this.DB[n2] != null && (object = this.DB[n2].getMailcapList(string)) != null) {
                this.appendPrefCmdsToVector((Hashtable)object, vector);
            }
            ++n2;
        }
        object = new CommandInfo[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    private void appendPrefCmdsToVector(Hashtable hashtable, Vector vector) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.checkForVerb(vector, string)) continue;
            Vector vector2 = (Vector)hashtable.get(string);
            String string2 = (String)vector2.firstElement();
            vector.addElement(new CommandInfo(string, string2));
        }
    }

    private boolean checkForVerb(Vector vector, String string) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = ((CommandInfo)enumeration.nextElement()).getCommandName();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public synchronized CommandInfo[] getAllCommands(String string) {
        Object object;
        Vector vector = new Vector();
        int n2 = 0;
        while (n2 < this.DB.length) {
            if (this.DB[n2] != null && (object = this.DB[n2].getMailcapList(string)) != null) {
                this.appendCmdsToVector((Hashtable)object, vector);
            }
            ++n2;
        }
        object = new CommandInfo[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    private void appendCmdsToVector(Hashtable hashtable, Vector vector) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector2 = (Vector)hashtable.get(string);
            Enumeration enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                vector.insertElementAt(new CommandInfo(string, string2), 0);
            }
        }
    }

    public synchronized CommandInfo getCommand(String string, String string2) {
        int n2 = 0;
        while (n2 < this.DB.length) {
            String string3;
            Vector vector;
            Hashtable hashtable;
            if (this.DB[n2] != null && (hashtable = this.DB[n2].getMailcapList(string)) != null && (vector = (Vector)hashtable.get(string2)) != null && (string3 = (String)vector.firstElement()) != null) {
                return new CommandInfo(string2, string3);
            }
            ++n2;
        }
        return null;
    }

    public synchronized void addMailcap(String string) {
        if (debug) {
            System.out.println("MailcapCommandMap: add to PROG");
        }
        if (this.DB[0] == null) {
            this.DB[0] = new MailcapFile();
        }
        this.DB[0].appendToMailcap(string);
    }

    public synchronized DataContentHandler createDataContentHandler(String string) {
        if (debug) {
            System.out.println("MailcapCommandMap: createDataContentHandler for " + string);
        }
        int n2 = 0;
        while (n2 < this.DB.length) {
            if (this.DB[n2] != null) {
                Vector vector;
                Hashtable hashtable;
                if (debug) {
                    System.out.println("  search DB #" + n2);
                }
                if ((hashtable = this.DB[n2].getMailcapList(string)) != null && (vector = (Vector)hashtable.get("content-handler")) != null) {
                    if (debug) {
                        System.out.println("    got content-handler");
                    }
                    try {
                        if (debug) {
                            System.out.println("      class " + (String)vector.firstElement());
                        }
                        return (DataContentHandler)Class.forName((String)vector.firstElement()).newInstance();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {}
                }
            }
            ++n2;
        }
        return null;
    }

    static {
        try {
            debug = Boolean.getBoolean("javax.activation.debug");
        }
        catch (Throwable throwable) {}
    }
}

